<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                              xmlns:wwtoc="urn:WebWorks-Engine-TOC-Schema"
                              xmlns:wwlinks="urn:WebWorks-Engine-Links-Schema"
                              xmlns:wwmode="urn:WebWorks-Engine-Mode"
                              xmlns:wwfiles="urn:WebWorks-Engine-Files-Schema"
                              xmlns:wwdoc="urn:WebWorks-Document-Schema"
                              xmlns:wwsplits="urn:WebWorks-Engine-Splits-Schema"
                              xmlns:wwproject="urn:WebWorks-Publish-Project"
                              xmlns:wwprogress="urn:WebWorks-XSLT-Extension-Progress"
                              xmlns:wwlog="urn:WebWorks-XSLT-Extension-Log"
                              xmlns:wwfilesystem="urn:WebWorks-XSLT-Extension-FileSystem"
                              xmlns:wwuri="urn:WebWorks-XSLT-Extension-URI"
                              xmlns:wwstring="urn:WebWorks-XSLT-Extension-StringUtilities"
                              xmlns:wwfilesext="urn:WebWorks-XSLT-Extension-Files"
                              xmlns:wwprojext="urn:WebWorks-XSLT-Extension-Project"
                              xmlns:wwexsldoc="urn:WebWorks-XSLT-Extension-Document"
                              xmlns:wwexec="urn:WebWorks-XSLT-Extension-Execute"
                              xmlns:wwenv="urn:WebWorks-XSLT-Extension-Environment"
                              exclude-result-prefixes="xsl msxsl wwtoc wwlinks wwmode wwfiles wwdoc wwsplits wwproject wwprogress wwlog wwfilesystem wwuri wwstring wwfilesext wwprojext wwexsldoc wwexec wwenv"
 >
 <xsl:param name="GlobalInput" />
 <xsl:param name="GlobalPipelineName" />
 <xsl:param name="GlobalProject" />
 <xsl:param name="GlobalFiles" />
 <xsl:param name="ParameterDependsType" />
 <xsl:param name="ParameterSplitsType" />
 <xsl:param name="ParameterType" />
 <xsl:param name="ParameterMergeTOCType" />
 <xsl:param name="ParameterMergeIndexType" />
 <xsl:param name="ParameterMergePageType" />
 <xsl:param name="ParameterMergeHHPType" />
 <xsl:param name="ParameterMergeType" />
 <xsl:param name="ParameterHHPSplitFileType" />
 <xsl:param name="ParameterCHMSplitFileType" />
 <xsl:param name="ParameterCategory" />
 <xsl:param name="ParameterUse" />
 <xsl:param name="ParameterDeploy" />
 <xsl:param name="ParameterMergeCategory" />
 <xsl:param name="ParameterMergeUse" />
 <xsl:param name="ParameterMergeDeploy" />

 <xsl:strip-space elements="*" />


 <xsl:key name="wwfiles-files-by-type" match="wwfiles:File" use="@type" />
 <xsl:key name="wwfiles-files-by-groupid-type" match="wwfiles:File" use="concat(@groupID, ':', @type)" />
 <xsl:key name="wwsplits-files-by-groupid-type" match="wwsplits:File" use="concat(@groupID, ':', @type)" />

 <xsl:variable name="GlobalTransformPath" select="wwuri:AsFilePath('wwtransform:self')" />
 <xsl:variable name="GlobalActionChecksum" select="concat($GlobalTransformPath, ':', wwfilesystem:GetChecksum($GlobalTransformPath))" />


 <xsl:template match="/">
  <wwfiles:Files version="1.0">

   <xsl:for-each select="$GlobalFiles[1]">
    <xsl:variable name="VarFilesByType" select="key('wwfiles-files-by-type', $ParameterDependsType)" />

    <xsl:variable name="VarProgressGroupsAndMergeStart" select="wwprogress:Start(count($VarFilesByType) + 1)" />

    <xsl:for-each select="$VarFilesByType">
     <xsl:variable name="VarProgressGroupStart" select="wwprogress:Start(1)" />

     <xsl:variable name="VarHHPDocumentNode" select="." />

     <!-- Load splits -->
     <!--             -->
     <xsl:variable name="VarFilesSplits" select="key('wwfiles-files-by-groupid-type', concat($VarHHPDocumentNode/@groupID, ':', $ParameterSplitsType))[1]" />
     <xsl:variable name="VarSplits" select="wwexsldoc:LoadXMLWithoutResolver($VarFilesSplits/@path)" />

     <xsl:for-each select="$VarSplits[1]">
      <xsl:variable name="VarCHMSplit" select="key('wwsplits-files-by-groupid-type', concat($VarHHPDocumentNode/@groupID, ':', $ParameterCHMSplitFileType))[1]" />
      <xsl:variable name="VarHHPSplit" select="key('wwsplits-files-by-groupid-type', concat($VarHHPDocumentNode/@groupID, ':', $ParameterHHPSplitFileType))" />

      <!-- Output Path -->
      <!--             -->
      <xsl:variable name="VarCHMPath" select="$VarCHMSplit/@path" />

      <!-- Call template -->
      <!--               -->
      <xsl:variable name="VarGroupFiles" select="$GlobalFiles//wwfiles:File[@groupID = $VarHHPDocumentNode/@groupID]" />
      <xsl:variable name="VarUpToDate" select="wwfilesext:UpToDate($VarCHMPath, concat($GlobalProject/wwproject:Project/@ChangeID, ':', count($VarGroupFiles)), $VarHHPDocumentNode/@groupID, '', $GlobalActionChecksum)" />
      <xsl:if test="not($VarUpToDate)">
       <xsl:variable name="VarResult">
        <xsl:call-template name="Compile">
         <xsl:with-param name="ParamHHPPath" select="$VarHHPSplit/@path" />
        </xsl:call-template>
       </xsl:variable>
      </xsl:if>

      <wwfiles:File path="{$VarCHMPath}" type="{$ParameterType}" checksum="{wwfilesystem:GetChecksum($VarCHMPath)}" projectchecksum="{concat($GlobalProject/wwproject:Project/@ChangeID, ':', count($VarGroupFiles))}" groupID="{$VarHHPDocumentNode/@groupID}" documentID="" actionchecksum="{$GlobalActionChecksum}" deploy="{$ParameterDeploy}" category="{$ParameterCategory}" use="{$ParameterUse}">
       <xsl:for-each select="$VarGroupFiles">
        <xsl:variable name="VarGroupFile" select="." />

        <xsl:if test="starts-with($VarGroupFile/@path, wwprojext:GetTargetOutputDirectoryPath())">
         <wwfiles:Depends path="{$VarGroupFile/@path}" checksum="{$VarGroupFile/@checksum}" groupID="{$VarGroupFile/@groupID}" documentID="{$VarGroupFile/@documentID}" />
        </xsl:if>
       </xsl:for-each>
      </wwfiles:File>

      </xsl:for-each>

     <xsl:variable name="VarProgressGroupEnd" select="wwprogress:End()" />
    </xsl:for-each>

    <!-- Merge -->
    <!--       -->
    <xsl:variable name="VarProjectGroups" select="$GlobalProject/wwproject:Project/wwproject:Groups/wwproject:Group" />
    <xsl:variable name="VarProgressMergeStart" select="wwprogress:Start(1)" />
    <xsl:if test="count($VarProjectGroups) &gt; 1">
     <!-- Merge HHP Path -->
     <!--                -->
     <xsl:variable name="VarMergeHPPFile" select="key('wwfiles-files-by-type', $ParameterMergeHHPType)[1]" />

     <!-- Merge path -->
     <!--            -->
     <xsl:variable name="VarMergePath" select="wwfilesystem:Combine(wwprojext:GetTargetOutputDirectoryPath(), concat(wwprojext:GetFormatName(), '.chm'))" />

     <!-- Up-to-date? -->
     <!--             -->
     <xsl:variable name="VarUpToDate" select="wwfilesext:UpToDate($VarMergePath, $GlobalProject/wwproject:Project/@ChangeID, '', '', $GlobalActionChecksum)" />
     <xsl:if test="not($VarUpToDate)">
      <xsl:variable name="VarResult">
       <xsl:call-template name="Compile">
        <xsl:with-param name="ParamHHPPath" select="$VarMergeHPPFile/@path" />
       </xsl:call-template>
      </xsl:variable>
     </xsl:if>

     <wwfiles:File path="{$VarMergePath}" type="{$ParameterMergeType}" checksum="{wwfilesystem:GetChecksum($VarMergePath)}" projectchecksum="{$GlobalProject/wwproject:Project/@ChangeID}" groupID="" documentID="" actionchecksum="{$GlobalActionChecksum}" category="{$ParameterMergeCategory}" use="{$ParameterMergeUse}" deploy="{$ParameterMergeDeploy}">
      <xsl:for-each select="$GlobalFiles[1]">
       <xsl:for-each select="key('wwfiles-files-by-type', $ParameterMergeTOCType)[1]">
        <wwfiles:Depends path="{./@path}" checksum="{./@checksum}" groupID="{./@groupID}" documentID="{./@documentID}" />
       </xsl:for-each>

       <xsl:for-each select="key('wwfiles-files-by-type', $ParameterMergeIndexType)[1]">
        <wwfiles:Depends path="{./@path}" checksum="{./@checksum}" groupID="{./@groupID}" documentID="{./@documentID}" />
       </xsl:for-each>

       <xsl:for-each select="key('wwfiles-files-by-type', $ParameterMergePageType)[1]">
        <wwfiles:Depends path="{./@path}" checksum="{./@checksum}" groupID="{./@groupID}" documentID="{./@documentID}" />
       </xsl:for-each>

       <wwfiles:Depends path="{$VarMergeHPPFile/@path}" checksum="{$VarMergeHPPFile/@checksum}" groupID="{$VarMergeHPPFile/@groupID}" documentID="{$VarMergeHPPFile/@documentID}" />
      </xsl:for-each>
     </wwfiles:File>
    </xsl:if>
    <xsl:variable name="VarProgressMergeEnd" select="wwprogress:End()" />

    <xsl:variable name="VarProgressGroupsAndMergeEnd" select="wwprogress:End()" />
   </xsl:for-each>

  </wwfiles:Files>
 </xsl:template>

 <xsl:template name="Compile">
  <xsl:param name="ParamHHPPath" />

  <!-- HTML Help Workshop Location -->
  <!--                             -->
  <xsl:variable name="VarHHCompiler" select="wwfilesystem:Combine(wwenv:HTMLHelpWorkshopPath(), 'hhc.exe')" />

  <!-- Compile CHM -->
  <!--             -->
  <xsl:variable name="VarExecuteCompileCommand" select="wwexec:ExecuteCommandInDirectory(wwfilesystem:GetDirectoryName($ParamHHPPath), $VarHHCompiler, $ParamHHPPath)" />

  <!-- Log result -->
  <!--            -->
  <xsl:if test="string-length($VarExecuteCompileCommand/wwexec:Result/wwexec:Stream[@name = 'Output']/text()) &gt; 0">
   <xsl:choose>
    <xsl:when test="$VarExecuteCompileCommand/wwexec:Result/@retcode = 1">
     <xsl:variable name="VarIgnoreOutput" select="wwlog:Message($VarExecuteCompileCommand/wwexec:Result/wwexec:Stream[@name = 'Output']/text())" />
    </xsl:when>

    <xsl:otherwise>
     <xsl:variable name="VarIgnoreOutput" select="wwlog:Warning($VarExecuteCompileCommand/wwexec:Result/wwexec:Stream[@name = 'Output']/text())" />
    </xsl:otherwise>
   </xsl:choose>
  </xsl:if>
  <xsl:if test="string-length($VarExecuteCompileCommand/wwexec:Result/wwexec:Stream[@name = 'Error']/text()) &gt; 0">
   <xsl:variable name="VarIgnoreError" select="wwlog:Warning($VarExecuteCompileCommand/wwexec:Result/wwexec:Stream[@name = 'Error']/text())" />
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
